{*
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 *}
<div class="panel">
    <h3><i class="icon icon-cogs"></i> {l s='Sync Products' mod='wiserreview'}</h3>

    <div class="panel-content">
		<div id="loader-sync">
			<div class="loading-text">{l s='Processing...' mod='wiserreview'}</div>
		</div>

		<div class="form-group">
            {if $unsynced > 0}
                <p class="alert alert-info">
                    {l
                        s='There are %d products that need to be synced. Click the Sync button to sync the products.'
                        sprintf=[$unsynced]
                        mod='wiserreview'
                    }
                </p>
            {else}
                <p class="alert alert-success">
                    {l
                        s='All products are already synced.'
                        mod='wiserreview'
                    }
                </p>
            {/if}
        </div>
    </div>

    <div class="panel-footer">
		<div class="text-right">
			<button 
				data-type="reset" class="btn btn-default reset-sync" 
				{* {if $ex_status == 'disable'}disabled{/if} *}
			> 
				<i class="icon-download"></i> {l s='Reset Sync Settings' mod='wiserreview'}
			</button>
			<button 
				data-type="sync-product" class="btn btn-success sync" 
				{* {if $ex_status == 'disable'}disabled{/if} *}
			>
				{l s='Sync Product' mod='wiserreview'}
			</button>
		</div>
    </div>
</div>

<script>
$(document).ready(function () {

	$('.reset-sync').on('click', function (e) {
        e.preventDefault();

        if (!confirm('Are you sure you want to reset synced products?')) {
            return;
        }

        let $btn = $(this);
        $btn.prop('disabled', true);
		$('#loader-sync').show();

        $.ajax({
            url: '{$ajax_admin_link}',
            type: 'POST',
            dataType: 'json',
            data: {
                ajax: 1,
                action: 'DeleteSyncedProducts'
            },
            success: function (response) {
                alert(response.message);
                $btn.prop('disabled', false);
				$('#loader-sync').hide();
                location.reload();
            },
            error: function () {
                alert('Something went wrong while resetting sync.');
                $btn.prop('disabled', false);
				$('#loader-sync').hide();
            }
        });
    });

    $('.sync').on('click', function (e) {
        e.preventDefault();

        let $btn = $(this);
        $btn.attr('disabled', true);
        $('#loader-sync').show();

        let action_type = $(this).data('type');

        let start = 0;
        let limit = 50;

        function processBatch() {
            $.ajax({
                url: '{$ajax_admin_link}',
                type: 'POST',
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'SyncProducts',
                    type: action_type,
                    start: start,
                },
                success: function (response) {
                    console.log(response, 'response--wiser');
                    let total = response.total;
                    if (start < total) {
                        start += limit;
						let completed = Math.min(start, total);
						$('.loading-text').html(
							'Processing... <span>(' + completed + ' of ' + total + ' completed)</span>'
						);
                        processBatch();
                    } else {
						$('.loading-text').html('Processing...');
                        $btn.attr('disabled', false);
                        $('#loader-sync').hide();
                        alert("Sync Completed: " + response.data.status);
                        location.reload();
                    }
                },
                error: function () {
                    $btn.attr('disabled', false);
                    $('#loader-sync').hide();
                    alert("Error syncing products.");
                }
            });

        }

        // Start first batch
        processBatch();
    });

});
</script>

<style>
	.active {
		background-color: #25b9d7;
	}
  	#date-range {
    	display: none;
  	}
  	.panel-content {
    	width: fit-content;
    	margin: auto;
  	}
	#loader-sync {
		display: none;
		position: absolute;
		top: 0;
		left: 0;
		background-color: rgba(0,0,0,0.8);
		width: 100%;
		height: 100%;
		z-index: 9;
	}
	.loading-text {
		display: flex;
		align-items: center;
		justify-content: center;
		height: 100%;
		font-size: 32px;
		color: #fff!important;
		font-weight: 800!important;
	}
	.loading-text span { 
		font-size: 20px;
	}
</style>