<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class WiserreviewAjaxModuleFrontController extends ModuleFrontController
{
    public $ajax = true;

    // public function initContent()
    // {
    //     parent::initContent();
    // }

    public function displayAjaxExportProducts()
    {
        $type = Tools::getValue('type');
        $action = Tools::getValue('export_action');

        if($type == 'date-range') {
            $start = Tools::getValue('start');
            $end = Tools::getValue('end');
        } else {
            $duration = Tools::getValue('duration');
            $end = date('Y-m-d');
            $start = date('Y-m-d', strtotime('-'.$duration.' days'));
        }
        
        $csvfile = '';
        $order_data = [];
        $orders_formatted = [];
        // $orders = Order::getOrdersIdByDate($start, $end);
        $id_shop = $this->context->shop->id;
        $status = (int) Configuration::get('WR_WISER_ORDER_STATUS_'.$id_shop);
        $sql = '
            SELECT DISTINCT o.id_order FROM ' . _DB_PREFIX_ . 'orders o
            WHERE o.date_add BETWEEN "' . $start . '" AND "' . $end . '" AND o.current_state = ' . $status . '
        ';
        
        $orders = Db::getInstance()->executeS($sql);

        if($action == 'fetch-orders') {
            $result = [
                'success' => true,
                'result' => (string) count($orders),
            ];
    
            die(json_encode($result));
        }

        foreach ($orders as $id_order) {
            $order = new Order($id_order);
            $order_data = $this->module->getFormattedOrderData($order);
            $orders_formatted[] = $order_data;
            if($action == 'send-campaign') {
                $this->module->postOrderToWiser(json_encode($order_data));
            }
        }

        if($action == 'download-csv') {
            $csvfile = $this->createCsv($orders_formatted);
        }
        
        $result = [
            'success' => true,
            'result' => $csvfile,
            'message' => '',
        ];

        die(json_encode($result));
    }

    private function createCsv($orders) 
    {
        $filename = 'orders_'.uniqid().'.csv';

        $file = _PS_MODULE_DIR_ . 'wiserreview/views/exports/'.$filename;
        
        $relativePath = 'modules/wiserreview/views/exports/' . $filename;
        $webPath = Tools::getShopDomainSsl(true) . __PS_BASE_URI__ . $relativePath;

        if (!file_exists(dirname($file))) {
            mkdir(dirname($file), 0755, true);
        }
        
        $handle = fopen($file, 'w');

        // Header
        fputcsv($handle, ['First Name', 'Last Name', 'Phone', 'Email', 'Product Title', 'Product URL', 'Product Image URL', 'Product Id', 'Reviewer Image URL', 'Order Date']);
        
        foreach ($orders as $order) {
            $customer = $order['customer'];
            foreach ($order['line_items'] as $product) {
                fputcsv($handle, [
                    $customer['first_name'],
                    $customer['last_name'],
                    $customer['phone'],
                    $customer['email'],
                    $product['name'],
                    $product['pu'],
                    $product['piu'],
                    $product['id'],
                    NULL,
                    $order['cdt'],
                ]);    
            }
        }

        fclose($handle);

        return $webPath;
    }

    public function displayAjaxSyncProducts()
    {
        $start = (int) Tools::getValue('start', 0);
        $limit = (int) Tools::getValue('limit', 50); // Default batch size: 50
        
        // Enforce batch size limits (min: 1, max: 100)
        if ($limit < 1) {
            $limit = 50;
        }
        if ($limit > 100) {
            $limit = 100;
        }
        
        $products = Product::getProducts(
            $this->context->language->id,
            $start,
            $limit,
            'id_product',
            'ASC'
        );

        // Optimize: Only check synced status for products in current batch
        $product_ids = array_column($products, 'id_product');
        $syncedMap = [];
        
        if (!empty($product_ids)) {
            $sql = 'SELECT id_product FROM `'._DB_PREFIX_.'product_sync_setting` 
                    WHERE id_product IN (' . implode(',', array_map('intval', $product_ids)) . ') 
                    AND is_synced = 1';
            $synced_in_batch = Db::getInstance()->executeS($sql);
            $syncedMap = array_flip(array_column($synced_in_batch, 'id_product'));
        }

        $data = [];
        $totalSynced = (int) Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'product_sync_setting` WHERE is_synced = 1');

        foreach ($products as $product) {
            if (isset($syncedMap[(int) $product['id_product']])) {
                continue;
            }
            $data[] = $this->module->prepareProductData($product);
        }

        $totalProducts = (int) Db::getInstance()->getValue('SELECT COUNT(*) FROM '._DB_PREFIX_.'product');

        if ($totalSynced === $totalProducts) {
            $msg = 'All products are already synced.';
        } elseif (empty($data)) {
            $msg = 'This batch contains only already synced products.';
        } else {
            $msg = 'Products synced successfully.';
        }

        if (!empty($data)) {
            $this->module->handleProductsApi($data);
            $this->module->saveSyncProducts(array_column($data, 'pid'));
        }

        die(json_encode([
            'total'  => $totalProducts,
            'data' => [
                'status' => $msg
            ]
        ]));
    }

    public function displayAjaxDeleteSyncedProducts()
    {
        $result = Db::getInstance()->execute('DELETE FROM '._DB_PREFIX_.'product_sync_setting');

        die(json_encode([
            'success' => (bool) $result,
            'message' => $result ? 'All synced products have been deleted.' : 'Failed to delete records.'
        ]));
    }

}
